%% DATI NUMERICI %% 

                                                    %INPUT DATA (COST DRIVERS) FOR RDTE & PROD

Conversion_MYr_to_Meuro = 310200/1000000;                                  %M€[2016]    

CEF_2013_to_2022 = 1.256;		
CEF_2016_to_2022 = 1.219;
CEF_2017_to_2022 = 1.194;

Mach_cruise= 5;
Mach_TJ= 4;
Z_maximum_TJ = 24300;                                                      %[m]
Z_cruise = 27000;                                                          %[m]
%[T_TJ, a_TJ, P_TJ, rho_TJ] = atmosisa(Z_maximum_TJ);                      %[K][m/s][Pa][kg/m^3]
%[T_cruise, a_cruise, P_cruise, rho_cruise] = atmosisa(Z_cruise);          %[K][m/s][Pa][kg/m^3]

a_TJ = 297.972126669811;                                                   %[m/s]
a_cruise = 299.591230978585;                                               %[m/s]

% number_aircrafts_to_build

N_MR5_to_build = 100;
N_MR5_to_build_vector = 1:1:100;

%learningcurve
percentage_learningcurve= 0.85;

%MASS COST DRIVERS

Mass_operating_empty_weight = 150000;                                      %[kg]
Mass_ATR_engine_dry = 4000;                                                %[kg]
Mass_DMR_engine_dry = 1400;                                                %[kg]
Mass_engine_dry = Mass_ATR_engine_dry + Mass_DMR_engine_dry;               %[kg]
Mass_operating_empty_weight_ton = Mass_operating_empty_weight/1000;        %[ton]

%COMBINED CYCLE COEFFICIENTS
C_complexity = 1.2;
K_tj = 0.6;
K_rj = 0.4;
K_tj_prod = 0.75;
K_rj_prod = 0.25;

%PERFORMANCE PARAMETERS

Maximum_operative_speed_TJ = Mach_TJ * a_TJ;                               %[m/s]

Cruise_speed = Mach_cruise * a_cruise;                                     %[m/s]
Cruise_speed_kmh = Cruise_speed/3.6;                                       %[km/h]

Ramjet_thrust = 600000;                                                    %[N]

LH2_Fuel_density = 70.85;                                                  %[kg/m^3]


Heat_flux = 715170;                                                        %[W/m^2] 
Heat_load = 3.06*1e10;                                                     %[J/m^2] 
Boil_off_flow_rate = 8;                                                    %[kg/s] 
Power_producedbyTEMS = 10.5*1e6;                                              %[W]

%TRL Function
trlx = [0,1,2,3,4,5,6,7,8,8.5,9];
trly = [0,0.0008,0.0015,0.0052,0.012,0.0464,0.1285,0.5755,0.9370,0.985,1];
trlq = 0:0.01:9;
pp = makima(trlx,trly,trlq);
polynomial = polyfit(trlq,pp,10);
f = polyval(polynomial,trlq);
K_TRL = polyval(polynomial,5);
% figure(50)
% plot(trlq,f,'r')
% hold on
% plot(trlx,trly,'o',trlq,pp,'b')
% K_TRL = 0.35;

% %Transcost coefficients

N_stages = 1;

f0 = 1.04;
f0primo = 1.03;
f1 = 1.3;
f2 = Mach_cruise^0.15;
f3 = 0.7;


for i=1:length(N_MR5_to_build_vector)
    f4(i) =((N_MR5_to_build_vector(i)).^(log(percentage_learningcurve)/log(2)));
end

f6 = 1;

n_parallel_contractors = 1;
f7 = n_parallel_contractors^0.2;
f8 = 0.86;
f9 = 1.2;
f10 = 0.8;
f11 = 0.5;
f10primo = 0.75;
f11primo = 0.6;

%% RDTE Vehicle Level
clc
format("bank")

%RDTE cost for Advanced Aircraft vehicle no-engine (with subsystem) [WYr] & [M€_2022]

M_vehicle_dry_noengine = Mass_operating_empty_weight - (6*Mass_ATR_engine_dry + Mass_DMR_engine_dry) ;

Hva_RDTE_MYr=(1746*(M_vehicle_dry_noengine.^0.284)).*(f2)*(f1*f3); %*f8*f10*f11

Hva_RDTE_MilioniEuro_2022 = Hva_RDTE_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022; 

%RDTE cost for turbojet engine [WYr] & [M€_2022]

Het_RDTE_MYr = (1380*(Mass_ATR_engine_dry^0.295)+1.12*Maximum_operative_speed_TJ)*f1*f3;

Het_RDTE_MilioniEuro_2022 = Het_RDTE_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022; 

%RDTE cost for ramjet engine [WYr] & [M€_2022]

Her_RDTE_MYr = 355*(Mass_DMR_engine_dry^0.295)*f1*f3;

Her_RDTE_MilioniEuro_2022 = Her_RDTE_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022; 

%RDTE cost for Combined Cycle Engine [WYr] & [M€_2022]

Hcce_RDTE_MYr = C_complexity*(K_tj*Het_RDTE_MYr + K_rj*Her_RDTE_MYr)*(f1*1.04545*f3);

Hcce_RDTE_MilioniEuro_2022 = Hcce_RDTE_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022; 

%Total RDTE cost [WYr] & [M€_2022]

Cost_TOT_RDTE_MYr = (Hva_RDTE_MYr + Hcce_RDTE_MYr + Her_RDTE_MYr)*(f0^N_stages)*f6*f7*f8;%(1-K_TRL);

Cost_TOT_RDTE_MilioniEuro_2022 = Cost_TOT_RDTE_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022; 

trl_cost = (1-pp)*Cost_TOT_RDTE_MilioniEuro_2022;

Cost_TOT_RDTE_MYr_TRL4 = Cost_TOT_RDTE_MYr*(1-K_TRL);

Cost_TOT_RDTE_MilioniEuro_2022_TRL4 = Cost_TOT_RDTE_MYr_TRL4 * Conversion_MYr_to_Meuro * CEF_2016_to_2022; 

Cost_TOT_RDTE_MYr_NOADDFACTORS = (Hva_RDTE_MYr + Hcce_RDTE_MYr + Her_RDTE_MYr);
Cost_TOT_RDTE_MilioniEuro_2022_NOADDFACTORS = Cost_TOT_RDTE_MYr_NOADDFACTORS * Conversion_MYr_to_Meuro * CEF_2016_to_2022; 

percentage_HVA_RDTE_OFTOT = Hva_RDTE_MYr/Cost_TOT_RDTE_MYr_NOADDFACTORS*100;
percentage_HET_RDTE_OFTOT = Het_RDTE_MYr/Cost_TOT_RDTE_MYr_NOADDFACTORS*100;
percentage_HER_RDTE_OFTOT = Her_RDTE_MYr/Cost_TOT_RDTE_MYr_NOADDFACTORS*100;
percentage_HCCE_RDTE_OFTOT = Hcce_RDTE_MYr/Cost_TOT_RDTE_MYr_NOADDFACTORS*100;
percentage_HCCE_HER_RDTE_OFTOT = (Hcce_RDTE_MYr + Her_RDTE_MYr)/Cost_TOT_RDTE_MYr_NOADDFACTORS*100;



RDTE_COSTS = ["Vehicle no-engine Cost";"Low speed Engine Cost";"High speed Engine Cost";"Combined Cycle Engine Cost";"STRATOFLY MR5 - overall RDTE Costs - (TRL 1 TO 9)";
              "STRATOFLY MR5 - overall RDTE Costs - (TRL 4 TO 9)"];
MYr = [Hva_RDTE_MYr;Het_RDTE_MYr;Her_RDTE_MYr;Hcce_RDTE_MYr;Cost_TOT_RDTE_MYr;Cost_TOT_RDTE_MYr_TRL4];
Milion_EUROs_2022= [Hva_RDTE_MilioniEuro_2022;Het_RDTE_MilioniEuro_2022;Her_RDTE_MilioniEuro_2022;Hcce_RDTE_MilioniEuro_2022;Cost_TOT_RDTE_MilioniEuro_2022;Cost_TOT_RDTE_MilioniEuro_2022_TRL4];
COSTI_VEHICLE_RDTE = table(RDTE_COSTS,MYr,Milion_EUROs_2022)

RDTE_COSTS_Percentages = ["Vehicle no-engine ";"ATR Engine Cost";"DMR Engine Cost";"STRATOFLY MR5 - overall RDTE Costs - No ADD Factors"];
MYr = [Hva_RDTE_MYr;Hcce_RDTE_MYr;Her_RDTE_MYr;Cost_TOT_RDTE_MYr_NOADDFACTORS];
Milion_EUROs_2022= [Hva_RDTE_MilioniEuro_2022;Hcce_RDTE_MilioniEuro_2022;Her_RDTE_MilioniEuro_2022;Cost_TOT_RDTE_MilioniEuro_2022_NOADDFACTORS];
Percentage=[percentage_HVA_RDTE_OFTOT;percentage_HCCE_RDTE_OFTOT;percentage_HER_RDTE_OFTOT;100.00];
Percentuali_VEHICLE_RDTE = table(RDTE_COSTS_Percentages,Milion_EUROs_2022,Percentage)

C_RDTE_MEAN_TOT_MILIONIEURO = Cost_TOT_RDTE_MilioniEuro_2022_TRL4  /  N_MR5_to_build;
C_RDTE_MEAN_HVA_MILIONIEURO = Hva_RDTE_MilioniEuro_2022 /  N_MR5_to_build;
C_RDTE_MEAN_HCCE_MILIONIEURO = Hcce_RDTE_MilioniEuro_2022 / N_MR5_to_build;
C_RDTE_MEAN_HER_MILIONIEURO = Her_RDTE_MilioniEuro_2022 / N_MR5_to_build;

RDTE_MEAN_COSTS = ["Vehile no-engine RDTE Mean Cost";"ATR Engine RDTE Mean Cost";"DMR Engine RDTE Mean Cost";"STRATOFLY MR5 - overall RDTE Mean Costs - TRL 4-9"];   
Milion_EUROs_2022_Mean_Costs = [C_RDTE_MEAN_HVA_MILIONIEURO;C_RDTE_MEAN_HCCE_MILIONIEURO;C_RDTE_MEAN_HER_MILIONIEURO;C_RDTE_MEAN_TOT_MILIONIEURO;];
Costo_Medio_RDTE = table(RDTE_MEAN_COSTS,Milion_EUROs_2022_Mean_Costs)

writetable(COSTI_VEHICLE_RDTE,'MR5.xlsx','Sheet','RDTE Vehicle Level','Range','A2');
writetable(Percentuali_VEHICLE_RDTE,'MR5.xlsx','Sheet','RDTE Vehicle Level','Range','A11');
writetable(Costo_Medio_RDTE,'MR5.xlsx','Sheet','RDTE Vehicle Level','Range','A19');

figure(1)
plot(trlq,trl_cost,'r','LineWidth',2)
xlabel({'Technology Readiness Level'})
ylabel({'STRATOFLY MR5 RDTE Cost ','[M€ FY2022]'})
ylim([0,30000])
hold on
grid on
f = figure(1);  
f.Position = [100 100 800 600]; 

%% RDTE SubSystem Level

format("bank")

%RDTE cost for fuel system [WYr]

    S_FUEL_RDTE_MYr = ((0.1*(Mass_operating_empty_weight^0.68))+(0.5*(LH2_Fuel_density^(-0.6)))+(0.49*(Mass_engine_dry^0.51)))*(1.1)*f3;

    S_FUEL_RDTE_MilioniEuro_2022 = S_FUEL_RDTE_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022;

%RDTE cost for TPS system [WYr]

    S_TPS_RDTE_MYr = ((0.56*(Mass_operating_empty_weight^0.59))+(1.8*(Heat_flux^0.51)))*(1.2)*f3;

    S_TPS_RDTE_MilioniEuro_2022 = S_TPS_RDTE_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022; 

%RDTE cost for TEMS [WYr]

    S_TEMS_RDTE_MYr = ((5.73*(Mass_operating_empty_weight^0.26))+(0.8*(Power_producedbyTEMS^0.17))+(0.53*(Boil_off_flow_rate^0.19)))*(1.4)*f3;

    S_TEMS_RDTE_MilioniEuro_2022 = S_TEMS_RDTE_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022; 

%SOMME
SUM_3_SubSYstem_RDTE_MYr = S_TEMS_RDTE_MYr + S_TPS_RDTE_MYr + S_FUEL_RDTE_MYr;

SUM_OTHER_SubSystem_RDTE_MYr = Hva_RDTE_MYr - SUM_3_SubSYstem_RDTE_MYr;

%Percentuali
percentage_S_FUEL_OFTOT = S_FUEL_RDTE_MYr/Cost_TOT_RDTE_MYr_NOADDFACTORS*100;
percentage_S_TPS_OFTOT = S_TPS_RDTE_MYr/Cost_TOT_RDTE_MYr_NOADDFACTORS*100;
percentage_S_TEMS_OFTOT = S_TEMS_RDTE_MYr/Cost_TOT_RDTE_MYr_NOADDFACTORS*100;

SUM_percentage_OTHER_SubSystem_OFTOT = SUM_OTHER_SubSystem_RDTE_MYr/Cost_TOT_RDTE_MYr_NOADDFACTORS*100;

scaling_percentage_for_subsystems = (SUM_percentage_OTHER_SubSystem_OFTOT)/(78.2-(0.4+2.8+0.2));

Integration_percentage = 17.8 * scaling_percentage_for_subsystems;
Structure_percentage =  47.1 * scaling_percentage_for_subsystems;
Landing_Gear_percentage = 0.4 * scaling_percentage_for_subsystems;
Environmental_Control_Subsystem_percentage = 1.6 * scaling_percentage_for_subsystems;
Ice_Protection_Subsystem_percentage =  0.5 * scaling_percentage_for_subsystems;
Fire_Protection_Subsystem_percentage = 0.6 * scaling_percentage_for_subsystems;
Flight_Control_Subsystem_percentage = 2.2 * scaling_percentage_for_subsystems;
Avionic_Subsystem_percentage = 0.7 * scaling_percentage_for_subsystems;
Electrical_Power_Subsystem_percentage = 2.6 * scaling_percentage_for_subsystems;
Water_Subsystem_percentage = 0.4 * scaling_percentage_for_subsystems;
Oxygen_Subsystem_percentage = 0.4 * scaling_percentage_for_subsystems;
Lights_Subsystem_percentage = 0.2 * scaling_percentage_for_subsystems;
Furnishing_percentage = 0.3 * scaling_percentage_for_subsystems;

Integration_cost = Integration_percentage*Cost_TOT_RDTE_MYr_NOADDFACTORS/100;
Structure_cost =  Structure_percentage*Cost_TOT_RDTE_MYr_NOADDFACTORS/100;
Landing_Gear_cost = Landing_Gear_percentage*Cost_TOT_RDTE_MYr_NOADDFACTORS/100;
Environmental_Control_Subsystem_cost = Environmental_Control_Subsystem_percentage*Cost_TOT_RDTE_MYr_NOADDFACTORS/100;
Ice_Protection_Subsystem_cost =  Ice_Protection_Subsystem_percentage*Cost_TOT_RDTE_MYr_NOADDFACTORS/100;
Fire_Protection_Subsystem_cost = Fire_Protection_Subsystem_percentage*Cost_TOT_RDTE_MYr_NOADDFACTORS/100;
Flight_Control_Subsystem_cost = Flight_Control_Subsystem_percentage*Cost_TOT_RDTE_MYr_NOADDFACTORS/100;
Avionic_Subsystem_cost = Avionic_Subsystem_percentage*Cost_TOT_RDTE_MYr_NOADDFACTORS/100;
Electrical_Power_Subsystem_cost = Electrical_Power_Subsystem_percentage*Cost_TOT_RDTE_MYr_NOADDFACTORS/100;
Water_Subsystem_cost = Water_Subsystem_percentage*Cost_TOT_RDTE_MYr_NOADDFACTORS/100;
Oxygen_Subsystem_cost = Oxygen_Subsystem_percentage*Cost_TOT_RDTE_MYr_NOADDFACTORS/100;
Lights_Subsystem_cost = Lights_Subsystem_percentage*Cost_TOT_RDTE_MYr_NOADDFACTORS/100;
Furnishing_cost = Furnishing_percentage*Cost_TOT_RDTE_MYr_NOADDFACTORS/100;

RDTE_Subsystem_COSTS = ["Propellant/Fuel Subsystem ";"Thermal Protection Subsystem (TPS)";"Thermal & Energy Management Subsystem (TEMS)"];                      
MYr = [ S_FUEL_RDTE_MYr;S_TPS_RDTE_MYr;S_TEMS_RDTE_MYr];
Milion_EUROs_2022 = [S_FUEL_RDTE_MilioniEuro_2022;S_TPS_RDTE_MilioniEuro_2022;S_TEMS_RDTE_MilioniEuro_2022];
Percentage=[percentage_S_FUEL_OFTOT;percentage_S_TPS_OFTOT;percentage_S_TEMS_OFTOT];
COSTI_SUBSYSTEMS = table(RDTE_Subsystem_COSTS,MYr,Milion_EUROs_2022,Percentage)

RDTE_Other_Subsystem_COSTS = ["Integration";"Structure";"Landing Gear";"Environmental Control Subsystem (ECS)";
                               "Ice_Protection_Subsystem (IPS)";"Fire Protection Subsystem (FPS)";"Flight Control Subsystem (FCS)";
                               "Avionic Subsystem";"Electrical Power Subsystem (EPS)";"Water Subsystem";"Oxygen Subsystem";
                               "Lights Subsystem";"Furnishing"];
Percentage = [Integration_percentage;Structure_percentage;Landing_Gear_percentage;Environmental_Control_Subsystem_percentage;
                Ice_Protection_Subsystem_percentage;Fire_Protection_Subsystem_percentage;Flight_Control_Subsystem_percentage;
                Avionic_Subsystem_percentage;Electrical_Power_Subsystem_percentage;Water_Subsystem_percentage;
                Oxygen_Subsystem_percentage;Lights_Subsystem_percentage;Furnishing_percentage];
MYr = [Integration_cost;Structure_cost;Landing_Gear_cost;Environmental_Control_Subsystem_cost;
                Ice_Protection_Subsystem_cost;Fire_Protection_Subsystem_cost;Flight_Control_Subsystem_cost;
                Avionic_Subsystem_cost;Electrical_Power_Subsystem_cost;Water_Subsystem_cost;
                Oxygen_Subsystem_cost;Lights_Subsystem_cost;Furnishing_cost];
Milion_EUROs_2022 = MYr.*(Conversion_MYr_to_Meuro * CEF_2016_to_2022);
format("shortG")            
COSTI_OTHER_SUBSYSTEMS = table(RDTE_Other_Subsystem_COSTS,Percentage,MYr,Milion_EUROs_2022)
                           
writetable(COSTI_SUBSYSTEMS,'MR5.xlsx','Sheet','RDTE SubSystem Level','Range','A2');
writetable(COSTI_OTHER_SUBSYSTEMS,'MR5.xlsx','Sheet','RDTE SubSystem Level','Range','A7');
% 
% subsystpie = [Hcce_RDTE_MilioniEuro_2022; Her_RDTE_MilioniEuro_2022; S_FUEL_RDTE_MilioniEuro_2022; S_TPS_RDTE_MilioniEuro_2022; S_TEMS_RDTE_MilioniEuro_2022]; 
% subsystpie2= [subsystpie; Milion_EUROs_2022];
% figure(1)
% pie(subsystpie2)
%% PROD Vehicle Level

format("bank")

%Production (PROD) cost for high speed advanced aircraft [WYr] & [M€_2022]
 
Fvf_PROD_MYr = (((0.34*Mass_operating_empty_weight_ton^1.75))+(7.06*(Cruise_speed_kmh^0.4))); %*f4(100);

Fvf_PROD_MilioniEuro_2022 = Fvf_PROD_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022;

figure(21)
for k = 1:length(N_MR5_to_build_vector)
      Fvf_PROD_MYr_LCURVE(k) = Fvf_PROD_MYr.* f4(k);
      Fvf_PROD_MilioniEuro_2022_LCURVE(k) = Fvf_PROD_MYr_LCURVE(k).* (Conversion_MYr_to_Meuro * CEF_2016_to_2022);
end
plot(N_MR5_to_build_vector,Fvf_PROD_MilioniEuro_2022_LCURVE,'g','DisplayName','Vehicle no-engine','LineWidth',1.5)
hold on

Mean_Ffv_MYr = (sum(Fvf_PROD_MYr_LCURVE))/N_MR5_to_build;
Mean_Ffv_MilioniEuro_2022 = Mean_Ffv_MYr* Conversion_MYr_to_Meuro * CEF_2016_to_2022;


%Production (PROD) cost for turbojet engine [WYr] & [M€_2022]

Fet_PROD_MYr = ((2.29*(Mass_ATR_engine_dry^0.53))+(0.5*(Maximum_operative_speed_TJ^0.6)));%*f4(100);

Fet_PROD_MilioniEuro_2022 = Fet_PROD_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022;

for k = 1:length(N_MR5_to_build_vector)
      Fet_PROD_MYr_LCURVE(k) = Fet_PROD_MYr.* f4(k);
      Fet_PROD_MilioniEuro_2022_LCURVE(k) = Fet_PROD_MYr_LCURVE(k).* (Conversion_MYr_to_Meuro * CEF_2016_to_2022);
end


Mean_Fet_MYr = (sum(Fet_PROD_MYr_LCURVE))/N_MR5_to_build;
Mean_Fet_MilioniEuro_2022 = Mean_Fet_MYr* Conversion_MYr_to_Meuro * CEF_2016_to_2022;

%Production cost for ramjet engine [WYr] & [M€_2022]

Fer_PROD_MYr = (5.63*((Ramjet_thrust/1000)^0.35));%*f4(100);

Fer_PROD_MilioniEuro_2022 = Fer_PROD_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022;

for k = 1:length(N_MR5_to_build_vector)
      Fer_PROD_MYr_LCURVE(k) = Fer_PROD_MYr.* f4(k);
      Fer_PROD_MilioniEuro_2022_LCURVE(k) = Fer_PROD_MYr_LCURVE(k).*( Conversion_MYr_to_Meuro * CEF_2016_to_2022);
end
plot(N_MR5_to_build_vector,Fer_PROD_MilioniEuro_2022_LCURVE,'r','DisplayName','DMR Engine','LineWidth',1.5)
hold on

Mean_Fer_MYr = (sum(Fer_PROD_MYr_LCURVE))/N_MR5_to_build;
Mean_Fer_MilioniEuro_2022 = Mean_Fer_MYr* Conversion_MYr_to_Meuro * CEF_2016_to_2022;

%Production cost for Combined Cycle Engine [WYr] & [M€_2022]

Fcce_PROD_MYr = C_complexity*(K_tj_prod*Fet_PROD_MYr+K_rj_prod*Fer_PROD_MYr);%*f4(100);

Fcce_PROD_MilioniEuro_2022 = Fcce_PROD_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022;

for k = 1:length(N_MR5_to_build_vector)
      Fcce_PROD_MYr_LCURVE(k) = Fcce_PROD_MYr.* f4(k);
      Fcce_PROD_MilioniEuro_2022_LCURVE(k) = Fcce_PROD_MYr_LCURVE(k).*( Conversion_MYr_to_Meuro * CEF_2016_to_2022);
end
plot(N_MR5_to_build_vector,Fcce_PROD_MilioniEuro_2022_LCURVE,'y','DisplayName','ATR Engine','LineWidth',1.5)
hold on

Mean_Fcce_MYr = (sum(Fcce_PROD_MYr_LCURVE))/N_MR5_to_build;
Mean_Fcce_MilioniEuro_2022 = Mean_Fcce_MYr* Conversion_MYr_to_Meuro * CEF_2016_to_2022;

%Total Production cost [WYr] & [M€_2022]

Cost_TOT_PROD_MYr = (Fvf_PROD_MYr + 6*Fcce_PROD_MYr + Fer_PROD_MYr)*f8*(f0primo^N_stages);

Cost_TOT_PROD_MilioniEuro_2022 = Cost_TOT_PROD_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022;

Cost_TOT_PROD_MYr_NOADDFACTORS = (Fvf_PROD_MYr + 6*Fcce_PROD_MYr + Fer_PROD_MYr);
Cost_TOT_PROD_MilioniEuro_2022_NOADDFACTORS = Cost_TOT_PROD_MYr_NOADDFACTORS * Conversion_MYr_to_Meuro * CEF_2016_to_2022;


for k = 1:length(N_MR5_to_build_vector)
      Cost_TOT_PROD_MYr_LCURVE(k) =(Fvf_PROD_MYr_LCURVE(k) + 6.*Fcce_PROD_MYr_LCURVE(k) + Fer_PROD_MYr_LCURVE(k)).*(f8*(f0primo^N_stages));
      Cost_TOT_PROD_MilioniEuro_2022_LCURVE(k) = Cost_TOT_PROD_MYr_LCURVE(k).* (Conversion_MYr_to_Meuro * CEF_2016_to_2022);
end
plot(N_MR5_to_build_vector,Cost_TOT_PROD_MilioniEuro_2022_LCURVE,'b','DisplayName','STRATOFLY MR5 - overall PROD Cost','LineWidth',1.5)
hold on
grid on
legend show
xlabel({'Aircraft Unit Produced'})
ylabel({'Production Cost ','[M€ FY2022]'})
f = figure(21);  
f.Position = [100 100 800 600]; 

Mean_Cost_TOT_MYr = (sum(Cost_TOT_PROD_MYr_LCURVE))/N_MR5_to_build;
Mean_Cost_TOT_MilioniEuro_2022 = Mean_Cost_TOT_MYr* Conversion_MYr_to_Meuro * CEF_2016_to_2022;

percentage_Fvf_PROD_OFTOT = Fvf_PROD_MYr/Cost_TOT_PROD_MYr_NOADDFACTORS*100;
percentage_Fet_PROD_OFTOT = Fet_PROD_MYr/Cost_TOT_PROD_MYr_NOADDFACTORS*100;
percentage_Fer_PROD_OFTOT = Fer_PROD_MYr/Cost_TOT_PROD_MYr_NOADDFACTORS*100;
percentage_Fcce_PROD_OFTOT = 6*Fcce_PROD_MYr/Cost_TOT_PROD_MYr_NOADDFACTORS*100;
percentage_Fcce_Fer_PROD_OFTOT = (6*Fcce_PROD_MYr + Fer_PROD_MYr)/Cost_TOT_PROD_MYr_NOADDFACTORS*100;


PROD_COSTS = ["Vehicle no-engine Cost";"Low speed Engine Cost";"High speed Engine Cost";"Combined Cycle Engine Cost";"STRATOFLY MR5 - overall PROD Costs - TFU"];
MYr = [Fvf_PROD_MYr;Fet_PROD_MYr;Fer_PROD_MYr;Fcce_PROD_MYr;Cost_TOT_PROD_MYr];
Milion_EUROs_2022= [Fvf_PROD_MilioniEuro_2022;Fet_PROD_MilioniEuro_2022;Fer_PROD_MilioniEuro_2022;Fcce_PROD_MilioniEuro_2022;Cost_TOT_PROD_MilioniEuro_2022];
COSTI_PROD = table(PROD_COSTS,MYr,Milion_EUROs_2022)


PROD_COSTS_Percentages = ["Vehicle no-engine ";"Single ATR Engine ";"ATR Engines ";"DMR Engine Cost";"STRATOFLY MR5 - overall PROD Costs - NO ADD FACTORS"];
MYr_ = [Fvf_PROD_MYr;Fcce_PROD_MYr;6*Fcce_PROD_MYr;Fer_PROD_MYr;Cost_TOT_PROD_MYr_NOADDFACTORS];
Milion_EUROs_2022= [Fvf_PROD_MilioniEuro_2022;Fcce_PROD_MilioniEuro_2022;6*Fcce_PROD_MilioniEuro_2022;Fer_PROD_MilioniEuro_2022;Cost_TOT_PROD_MilioniEuro_2022_NOADDFACTORS];
Percentage=[percentage_Fvf_PROD_OFTOT;percentage_Fcce_PROD_OFTOT/6;percentage_Fcce_PROD_OFTOT;percentage_Fer_PROD_OFTOT;100.00];
Percentuali_PROD = table(PROD_COSTS_Percentages,Milion_EUROs_2022,Percentage)



AIRCRAFT_BUILD = ["TFU";"2° Unit";"3° Unit";"5° Unit";"10° Unit";"25° Unit";"50° Unit";"100° Unit";"Mean Cost of 100 Units"];

Vehicle_no_engine_M_EURO = [Fvf_PROD_MilioniEuro_2022_LCURVE(1);Fvf_PROD_MilioniEuro_2022_LCURVE(2);Fvf_PROD_MilioniEuro_2022_LCURVE(3);
                            Fvf_PROD_MilioniEuro_2022_LCURVE(5);Fvf_PROD_MilioniEuro_2022_LCURVE(10);Fvf_PROD_MilioniEuro_2022_LCURVE(25);
                            Fvf_PROD_MilioniEuro_2022_LCURVE(50);Fvf_PROD_MilioniEuro_2022_LCURVE(100);Mean_Ffv_MilioniEuro_2022;];
                     
ATR_Engine_M_EURO = [Fcce_PROD_MilioniEuro_2022_LCURVE(1);Fcce_PROD_MilioniEuro_2022_LCURVE(2);Fcce_PROD_MilioniEuro_2022_LCURVE(3);
                            Fcce_PROD_MilioniEuro_2022_LCURVE(5);Fcce_PROD_MilioniEuro_2022_LCURVE(10);Fcce_PROD_MilioniEuro_2022_LCURVE(25);
                            Fcce_PROD_MilioniEuro_2022_LCURVE(50);Fcce_PROD_MilioniEuro_2022_LCURVE(100);Mean_Fcce_MilioniEuro_2022;];
                        
DMR_Engine_M_EURO = [Fer_PROD_MilioniEuro_2022_LCURVE(1);Fer_PROD_MilioniEuro_2022_LCURVE(2);Fer_PROD_MilioniEuro_2022_LCURVE(3);
                            Fer_PROD_MilioniEuro_2022_LCURVE(5);Fer_PROD_MilioniEuro_2022_LCURVE(10);Fer_PROD_MilioniEuro_2022_LCURVE(25);
                            Fer_PROD_MilioniEuro_2022_LCURVE(50);Fer_PROD_MilioniEuro_2022_LCURVE(100);Mean_Fer_MilioniEuro_2022;];                        
STRATOFLY_MR5_overall_PROD_Costs = [Cost_TOT_PROD_MilioniEuro_2022_LCURVE(1);Cost_TOT_PROD_MilioniEuro_2022_LCURVE(2);Cost_TOT_PROD_MilioniEuro_2022_LCURVE(3);
                                    Cost_TOT_PROD_MilioniEuro_2022_LCURVE(5);Cost_TOT_PROD_MilioniEuro_2022_LCURVE(10);Cost_TOT_PROD_MilioniEuro_2022_LCURVE(25);
                                    Cost_TOT_PROD_MilioniEuro_2022_LCURVE(50);Cost_TOT_PROD_MilioniEuro_2022_LCURVE(100);Mean_Cost_TOT_MilioniEuro_2022];                       
Learning_curve = table(AIRCRAFT_BUILD,Vehicle_no_engine_M_EURO,ATR_Engine_M_EURO,DMR_Engine_M_EURO,STRATOFLY_MR5_overall_PROD_Costs)

writetable(COSTI_PROD,'MR5.xlsx','Sheet','PROD Vehicle Level','Range','A2');
writetable(Percentuali_PROD,'MR5.xlsx','Sheet','PROD Vehicle Level','Range','A10');
writetable(Learning_curve,'MR5.xlsx','Sheet','PROD Vehicle Level','Range','A18');



%% PROD Subsystem Level

format("bank")

%PROD cost for fuel system [WYr] & [M€_2022]

    S_FUEL_PROD_MYr = ((0.48*(Mass_operating_empty_weight^0.38))+(0.5*(Mass_engine_dry^0.39)));%*f4_n;

    S_FUEL_PROD_MilioniEuro_2022 = S_FUEL_PROD_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022;

for k = 1:length(N_MR5_to_build_vector)
      S_FUEL_PROD_MYr_LCURVE(k) = S_FUEL_PROD_MYr.* f4(k);
      S_FUEL_PROD_MilioniEuro_2022_LCURVE(k) = S_FUEL_PROD_MYr_LCURVE(k).* (Conversion_MYr_to_Meuro * CEF_2016_to_2022);
end

Mean_S_FUEL_MYr = (sum(S_FUEL_PROD_MYr_LCURVE))/N_MR5_to_build;
Mean_S_FUEL_MilioniEuro_2022 = Mean_S_FUEL_MYr* Conversion_MYr_to_Meuro * CEF_2016_to_2022;

%PROD cost for TPS system [WYr] & [M€_2022]

    S_TPS_PROD_MYr = ((0.51*(Mass_operating_empty_weight^0.19))+(3.41*(Heat_flux^0.12))+(0.68*(Heat_load^0.11)));%*f4_n;

    S_TPS_PROD_MilioniEuro_2022 = S_TPS_PROD_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022; 

for k = 1:length(N_MR5_to_build_vector)
      S_TPS_PROD_MYr_LCURVE(k) = S_TPS_PROD_MYr.* f4(k);
      S_TPS_PROD_MilioniEuro_2022_LCURVE(k) = S_TPS_PROD_MYr_LCURVE(k).* (Conversion_MYr_to_Meuro * CEF_2016_to_2022);
end

Mean_S_TPS_MYr = (sum(S_TPS_PROD_MYr_LCURVE))/N_MR5_to_build;
Mean_S_TPS_MilioniEuro_2022 = Mean_S_TPS_MYr* Conversion_MYr_to_Meuro * CEF_2016_to_2022;

%PROD cost for TEMS [WYr] & [M€_2022]

    S_TEMS_PROD_MYr = (5.41*((Mass_operating_empty_weight^0.23))+(0.79*(Power_producedbyTEMS^0.15))+(0.52*(Boil_off_flow_rate^0.19)));%*f4_n;
    
    S_TEMS_PROD_MilioniEuro_2022 = S_TEMS_PROD_MYr * Conversion_MYr_to_Meuro * CEF_2016_to_2022; 

for k = 1:length(N_MR5_to_build_vector)
      S_TEMS_PROD_MYr_LCURVE(k) = S_TEMS_PROD_MYr.* f4(k);
      S_TEMS_PROD_MilioniEuro_2022_LCURVE(k) = S_TEMS_PROD_MYr_LCURVE(k).* (Conversion_MYr_to_Meuro * CEF_2016_to_2022);
end

Mean_S_TEMS_MYr = (sum(S_TEMS_PROD_MYr_LCURVE))/N_MR5_to_build;
Mean_S_TEMS_MilioniEuro_2022 = Mean_S_TEMS_MYr* Conversion_MYr_to_Meuro * CEF_2016_to_2022;

%SOMME
SUM_3_SubSYstem_PROD_MYr = S_TEMS_PROD_MYr + S_TPS_PROD_MYr + S_FUEL_PROD_MYr;

SUM_OTHER_SubSystem_PROD_MYr = Fvf_PROD_MYr - SUM_3_SubSYstem_PROD_MYr;

%Percentuali
percentage_S_FUEL_PROD_OFTOT = S_FUEL_PROD_MYr/Cost_TOT_PROD_MYr_NOADDFACTORS*100;
percentage_S_TPS_PROD_OFTOT = S_TPS_PROD_MYr/Cost_TOT_PROD_MYr_NOADDFACTORS*100;
percentage_S_TEMS_PROD_OFTOT = S_TEMS_PROD_MYr/Cost_TOT_PROD_MYr_NOADDFACTORS*100;

SUM_percentage_OTHER_SubSystem__PROD_OFTOT = SUM_OTHER_SubSystem_PROD_MYr/Cost_TOT_PROD_MYr_NOADDFACTORS*100;

scaling_percentage_for_subsystems_PROD = (SUM_percentage_OTHER_SubSystem__PROD_OFTOT)/(80.01-(1.3+0.7+2)); %sul PDF è 78 ma sommando esce 80.2

Integration_percentage_PROD = 2.1 * scaling_percentage_for_subsystems_PROD;
Structure_percentage_PROD =  49.2 * scaling_percentage_for_subsystems_PROD;
Landing_Gear_percentage_PROD = 0.8 * scaling_percentage_for_subsystems_PROD;
Environmental_Control_Subsystem_percentage_PROD = 2.4 * scaling_percentage_for_subsystems_PROD;
Ice_Protection_Subsystem_percentage_PROD =  0.7 * scaling_percentage_for_subsystems_PROD;
Fire_Protection_Subsystem_percentage_PROD = 0.2 * scaling_percentage_for_subsystems_PROD;
Flight_Control_Subsystem_percentage_PROD = 2.2 * scaling_percentage_for_subsystems_PROD;
Avionic_Subsystem_percentage_PROD = 0.8 * scaling_percentage_for_subsystems_PROD;
Electrical_Power_Subsystem_percentage_PROD = 16.8 * scaling_percentage_for_subsystems_PROD;
Water_Subsystem_percentage_PROD = 0.1 * scaling_percentage_for_subsystems_PROD;
Oxygen_Subsystem_percentage_PROD = 0.6 * scaling_percentage_for_subsystems_PROD;
Lights_Subsystem_percentage_PROD = 0.1 * scaling_percentage_for_subsystems_PROD;
Furnishing_percentage_PROD = 0.01 * scaling_percentage_for_subsystems_PROD;

Integration_PROD_cost = Integration_percentage_PROD*Cost_TOT_PROD_MYr_NOADDFACTORS/100;
Structure_PROD_cost =  Structure_percentage_PROD*Cost_TOT_PROD_MYr_NOADDFACTORS/100;
Landing_Gear_PROD_cost = Landing_Gear_percentage_PROD*Cost_TOT_PROD_MYr_NOADDFACTORS/100;
Environmental_Control_Subsystem_PROD_cost = Environmental_Control_Subsystem_percentage_PROD*Cost_TOT_PROD_MYr_NOADDFACTORS/100;
Ice_Protection_Subsystem_PROD_cost =  Ice_Protection_Subsystem_percentage_PROD*Cost_TOT_PROD_MYr_NOADDFACTORS/100;
Fire_Protection_Subsystem_PROD_cost = Fire_Protection_Subsystem_percentage_PROD*Cost_TOT_PROD_MYr_NOADDFACTORS/100;
Flight_Control_Subsystem_PROD_cost = Flight_Control_Subsystem_percentage_PROD*Cost_TOT_PROD_MYr_NOADDFACTORS/100;
Avionic_Subsystem_PROD_cost = Avionic_Subsystem_percentage_PROD*Cost_TOT_PROD_MYr_NOADDFACTORS/100;
Electrical_Power_Subsystem_PROD_cost = Electrical_Power_Subsystem_percentage_PROD*Cost_TOT_PROD_MYr_NOADDFACTORS/100;
Water_Subsystem_PROD_cost = Water_Subsystem_percentage_PROD*Cost_TOT_PROD_MYr_NOADDFACTORS/100;
Oxygen_Subsystem_PROD_cost = Oxygen_Subsystem_percentage_PROD*Cost_TOT_PROD_MYr_NOADDFACTORS/100;
Lights_Subsystem_PROD_cost = Lights_Subsystem_percentage_PROD*Cost_TOT_PROD_MYr_NOADDFACTORS/100;
Furnishing_PROD_cost = Furnishing_percentage_PROD*Cost_TOT_PROD_MYr_NOADDFACTORS/100;


PROD_Subsystem_COSTS = ["Propellant/Fuel Subsystem ";"Thermal Protection Subsystem (TPS)";"Thermal & Energy Management Subsystem (TEMS)"];                      
MYr = [S_FUEL_PROD_MYr;S_TPS_PROD_MYr;S_TEMS_PROD_MYr];
Milion_EUROs_2022 = [S_FUEL_PROD_MilioniEuro_2022;S_TPS_PROD_MilioniEuro_2022;S_TEMS_PROD_MilioniEuro_2022];
Percentage=[percentage_S_FUEL_PROD_OFTOT;percentage_S_TPS_PROD_OFTOT;percentage_S_TEMS_PROD_OFTOT];
Sottosistemi_PROD = table(PROD_Subsystem_COSTS,MYr,Milion_EUROs_2022,Percentage)


PROD_Other_Subsystem_COSTS = ["Integration";"Structure";"Landing Gear";"Environmental Control Subsystem (ECS)";
                               "Ice_Protection_Subsystem (IPS)";"Fire Protection Subsystem (FPS)";"Flight Control Subsystem (FCS)";
                               "Avionic Subsystem";"Electrical Power Subsystem (EPS)";"Water Subsystem";"Oxygen Subsystem";
                               "Lights Subsystem";"Furnishing"];
Percentage = [Integration_percentage_PROD;Structure_percentage_PROD;Landing_Gear_percentage_PROD;Environmental_Control_Subsystem_percentage_PROD;
                Ice_Protection_Subsystem_percentage_PROD;Fire_Protection_Subsystem_percentage_PROD;Flight_Control_Subsystem_percentage_PROD;
                Avionic_Subsystem_percentage_PROD;Electrical_Power_Subsystem_percentage_PROD;Water_Subsystem_percentage_PROD;
                Oxygen_Subsystem_percentage_PROD;Lights_Subsystem_percentage_PROD;Furnishing_percentage_PROD];
MYr = [Integration_PROD_cost;Structure_PROD_cost;Landing_Gear_PROD_cost;Environmental_Control_Subsystem_PROD_cost;
                Ice_Protection_Subsystem_PROD_cost;Fire_Protection_Subsystem_PROD_cost;Flight_Control_Subsystem_PROD_cost;
                Avionic_Subsystem_PROD_cost;Electrical_Power_Subsystem_PROD_cost;Water_Subsystem_PROD_cost;
                Oxygen_Subsystem_PROD_cost;Lights_Subsystem_PROD_cost;Furnishing_PROD_cost];
Milion_EUROs_2022 = MYr.*(Conversion_MYr_to_Meuro * CEF_2016_to_2022);
format("bank")            
OTHERSottosistemi = table(PROD_Other_Subsystem_COSTS,Percentage,MYr,Milion_EUROs_2022)





Subsystem_COSTS = ["Propellant/Fuel Subsystem ";"Thermal Protection Subsystem (TPS)";"Thermal & Energy Management Subsystem (TEMS)";"Integration";"Structure";"Landing Gear";"Environmental Control Subsystem (ECS)";
                               "Ice_Protection_Subsystem (IPS)";"Fire Protection Subsystem (FPS)";"Flight Control Subsystem (FCS)";
                               "Avionic Subsystem";"Electrical Power Subsystem (EPS)";"Water Subsystem";"Oxygen Subsystem";
                               "Lights Subsystem";"Furnishing";"Vehicle no-engine"];
PROD_Percentage = [percentage_S_FUEL_PROD_OFTOT;percentage_S_TPS_PROD_OFTOT;percentage_S_TEMS_PROD_OFTOT;Integration_percentage_PROD;Structure_percentage_PROD;Landing_Gear_percentage_PROD;Environmental_Control_Subsystem_percentage_PROD;
                Ice_Protection_Subsystem_percentage_PROD;Fire_Protection_Subsystem_percentage_PROD;Flight_Control_Subsystem_percentage_PROD;
                Avionic_Subsystem_percentage_PROD;Electrical_Power_Subsystem_percentage_PROD;Water_Subsystem_percentage_PROD;
                Oxygen_Subsystem_percentage_PROD;Lights_Subsystem_percentage_PROD;Furnishing_percentage_PROD;percentage_Fvf_PROD_OFTOT];
PROD_MYr = [S_FUEL_PROD_MYr;S_TPS_PROD_MYr;S_TEMS_PROD_MYr;Integration_PROD_cost;Structure_PROD_cost;Landing_Gear_PROD_cost;Environmental_Control_Subsystem_PROD_cost;
                Ice_Protection_Subsystem_PROD_cost;Fire_Protection_Subsystem_PROD_cost;Flight_Control_Subsystem_PROD_cost;
                Avionic_Subsystem_PROD_cost;Electrical_Power_Subsystem_PROD_cost;Water_Subsystem_PROD_cost;
                Oxygen_Subsystem_PROD_cost;Lights_Subsystem_PROD_cost;Furnishing_PROD_cost;Fvf_PROD_MYr];
PROD_Milion_EUROs_2022 = PROD_MYr.*(Conversion_MYr_to_Meuro * CEF_2016_to_2022);

RDTE_Percentage = [percentage_S_FUEL_OFTOT;percentage_S_TPS_OFTOT;percentage_S_TEMS_OFTOT;Integration_percentage;Structure_percentage;Landing_Gear_percentage;Environmental_Control_Subsystem_percentage;
                Ice_Protection_Subsystem_percentage;Fire_Protection_Subsystem_percentage;Flight_Control_Subsystem_percentage;
                Avionic_Subsystem_percentage;Electrical_Power_Subsystem_percentage;Water_Subsystem_percentage;
                Oxygen_Subsystem_percentage;Lights_Subsystem_percentage;Furnishing_percentage;percentage_HVA_RDTE_OFTOT];
RDTE_MYr = [S_FUEL_RDTE_MYr;S_TPS_RDTE_MYr;S_TEMS_RDTE_MYr;Integration_cost;Structure_cost;Landing_Gear_cost;Environmental_Control_Subsystem_cost;
                Ice_Protection_Subsystem_cost;Fire_Protection_Subsystem_cost;Flight_Control_Subsystem_cost;
                Avionic_Subsystem_cost;Electrical_Power_Subsystem_cost;Water_Subsystem_cost;
                Oxygen_Subsystem_cost;Lights_Subsystem_cost;Furnishing_cost;Hva_RDTE_MYr];
RDTE_Milion_EUROs_2022 = RDTE_MYr.*(Conversion_MYr_to_Meuro * CEF_2016_to_2022);


Confronto_sottosistemi  = table(Subsystem_COSTS,RDTE_Percentage,RDTE_Milion_EUROs_2022,PROD_Percentage,PROD_Milion_EUROs_2022)


writetable(Sottosistemi_PROD,'MR5.xlsx','Sheet','PROD Subsystem Level','Range','A2');
writetable(OTHERSottosistemi,'MR5.xlsx','Sheet','PROD Subsystem Level','Range','A7');
writetable(Confronto_sottosistemi,'MR5.xlsx','Sheet','PROD Subsystem Level','Range','A22');

